import { View, Text, FlatList, TouchableOpacity } from "react-native";
import React from "react";
import { cartStyle } from "./shoppingCartStyle";
import dpr from "../Utilities/CustomStyleAttribute/dpr";
import DeleteIcon from "../../assets/svgs/my wishlist/delete icon.svg";
import Checkbox from "expo-checkbox";
import SingleProduct from "./SingleCartItem";
import useAuth from "../../hooks/useAuth";
import { useDispatch } from "react-redux";
import { deleteGroupItems } from "../../redux/slices/cart/deleteCartItem/deleteGroupItems";
import { deleteGroupItemsFromCart } from "../../redux/slices/cart/getCartProducts";

import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../hooks/useLangTranslation";
import CustomSVG from "../../src/components/CustomSVG/CustomSVG";

const SellerGroup = ({
    item,
    isGroupCheck,
    handleGroupCheck,
    isCheck,
    handleCheck,
    handleIncrement,
    handleDecrement,
}) => {
    const { trans } = useLangTranslation();
    const dispatch = useDispatch();
    const { access_token } = useAuth();
    const deleteGroupURL = `${BASE_API_URL_STG}/user/cart/selected-delete`;
    let newArr = isGroupCheck.map((str) => Number(str));
    let isGrpDisable = item?.items?.filter(
        (i) => i.inventoryEnable == false || i.availability == 0
    ).length;
    const estimatedDelivery = {
        minDays: Infinity,
        maxDays: -Infinity,
    };
    for (let i of item?.items) {
        let dayNumber = Number(i?.estimated_delivery);
        if (dayNumber < estimatedDelivery.minDays) {
            estimatedDelivery.minDays = dayNumber;
        }
        if (dayNumber > estimatedDelivery.maxDays) {
            estimatedDelivery.maxDays = dayNumber;
        }
    }

    const handleGroupDelete = () => {
        const groupIds = item?.items?.map((item) => Number(item.id));
        const data = {
            id: `[${groupIds}]`,
        };
        dispatch(deleteGroupItemsFromCart(groupIds));
        dispatch(
            deleteGroupItems({
                access_token,
                deleteGroupURL,
                method: "POST",
                data,
            })
        );
    };
    return (
        <View style={cartStyle.items}>
            <View style={cartStyle.itemsHeader}>
                <View style={cartStyle.deleteAllCont}>
                     <TouchableOpacity hitSlop={6} onPress={() => handleGroupCheck(!newArr.includes(Number(item.vendor_id)), Number(item.vendor_id))} style={cartStyle.checkBoxCont}>
                        <Checkbox
                            disabled={isGrpDisable == 1 ? true : false}
                            value={newArr.includes(Number(item.vendor_id))}
                            onValueChange={(e) =>
                                handleGroupCheck(e, Number(item.vendor_id))
                            }
                            color={
                                newArr.includes(Number(item.vendor_id))
                                    ? "#2C2C2C"
                                    : "#DFDFDF"
                            }
                            style={cartStyle.checkBoxSize}
                        />
                    </TouchableOpacity>
                    <Text style={[cartStyle.deleteText, cartStyle.sellerName]}>
                        {item.vendor_name}
                    </Text>
                </View>
                <TouchableOpacity onPress={handleGroupDelete}>
                    <CustomSVG svgIcon={DeleteIcon}
                        height={dpr(14)}
                        width={dpr(14)}
                        fill={"#898989"}
                    />
                </TouchableOpacity>
            </View>
            <FlatList
                data={item.items}
                renderItem={({ item }) => (
                    <SingleProduct
                        item={item}
                        isCheck={isCheck}
                        handleCheck={handleCheck}
                        handleIncrement={handleIncrement}
                        handleDecrement={handleDecrement}
                    />
                )}
                keyExtractor={(_, i) => "key" + i}
                showsVerticalScrollIndicator={false}
            />
            <View style={cartStyle.itemFooter}>
                <Text style={cartStyle.footerText}>
                    {trans("Estimated Time: {{x}} days", {x: estimatedDelivery.minDays == estimatedDelivery.maxDays ? estimatedDelivery.minDays : `${estimatedDelivery.minDays} - ${estimatedDelivery.maxDays}`})}
                </Text>
            </View>
        </View>
    );
};

export default SellerGroup;
